--Initial campaign triggers (static file, not updated)
--Copied to Status/camp_triggers.lua in first mission and subsequently read and updated there
--Campaign triggers are defined with conditions and actions
-------------------------------------------------------------------------------------------------------

--List of Return functions to build conditions:
--Return.Time()												returns time of day in seconds
--Return.Day()												returns day of month
--Return.Month()											returns month as number
--Return.Year()												returns year as number
--Return.Mission()											returns campaign mission number
--Return.CampFlag(flag-n)									returns value of campaign flag
--Return.AirUnitActive("UnitName")							returned boolean whether the air unit is active			
--Return.AirUnitReady("UnitName")							returns amount of ready aircraft in unit
--Return.AirUnitAlive("UnitName")							returns amount of ready and damaged aircraft in unit
--Return.AirUnitBase("UnitName")							returns the name of the airbase the unit operats from
--Return.AirUnitPlayer("UnitName")							returns boolean whether the air units is playable
--Return.TargetAlive("TargetName")							returns percentage of alive sub elements in target
--Return.UnitDead(unitname)									(ADD) return vehicle/ship units dead (ADD)
--Return.GroupHidden("GroupName")							returns group hidden status
--Return.GroupProbability("GroupName")						returns group spawn probability value between 0 and 1
--Return.ShipGroupInPoly(GroupName, PolyZonesTable)			(ADD) return boolean whether ship group is in polygon (ADD)
--Return.PlaceLogistic("AirbaseName")						returns the logistics of a base in weight which can be increased by the landing of transport aircraft or helicopters


--List of Action functions for trigger actions:
--Action.None()																				--void action
--Action.Text("your briefing text")															--add briefing text
--Action.TextPlayMission(arg)																--add trigger text to briefing text of this mission only if it is playable
--Action.SetCampFlag(flag-n, boolean/number)												--set campagn flag to value
--Action.AddCampFlag(flag-n, number)														--add or subtract to campaign flag
--Action.AddImage("filname.jpg")															--add briefing picture
--Action.CampaignEnd("win"/"draw"/"loss")													--end campaign
--Action.TargetActive("TargetName", boolean)												--set target active/inactive
--Action.AirUnitActive("UnitName", boolean)													--set unit active/inactive
--Action.SideBase("side", "BaseName")														--change le camp d'une base, ATTENTION, deplacer les unites avant--Action.SideBase("blue", "Incirlik Airbase")
--Action.AirUnitBase("UnitName", "BaseName")												--set unit base
--Action.AirUnitPlayer("UnitName", boolean)													--set unit playable
--Action.AirUnitReinforce("SourceUnitName", "DestinationUnitName", destNumber)                --old transfer solution
--Action.AirUnitReinforce("SourceUnitName", "DestinationUnitName")                            --intermediate solution that does not require the number of aircraft to be transferred, since this number is in the reserve squadron
--Action.AirUnitReinforce("DestinationUnitName")                                            --simplified solution, but you need the line "reserve = number" in the active squadron
--Action.AirUnitRepair()																	--repair damaged aircraft in all air units
--Action.GroundUnitRepair()																	-- (ADD) M19.f : Repair Ground
--Action.AddGroundTargetIntel("sideName")													--add ground target intel updates to briefing
--Action.GroupHidden("GroupName", boolean)													--change vehicle/ship group hidden status
--Action.GroupProbability("GroupName", number 0-1)											--change vehicle/ship group probability status
																							--due to the way stats are reset for a new playrun upon completing a FirstMission, groups probability changed by trigger in first mission will not be carried over to second mission! Repeat trigger on second mission or use the trigger from mission 2 on only for flawless function.
--Action.GroupMove(GroupName, ZoneName)														-- (ADD) move vehicle group to refpoint (See the DC_CheckTriggers.lua file for more explanation)
--Action.GroupSlave(GroupName, master, bearing, distance)									-- (ADD)
--Action.ShipMission(GroupName, WPtable, CruiseSpeed, PatrolSpeed, StartTime)				-- (ADD) assign and run a movement mission to a ship group (See the DC_CheckTriggers.lua file for more explanation)
--Action.TemplateActive(TabFile)															-- (ADD) M40 : Template Active GroundGroup moving front (single file : active template) (if tab file: random activation)



--Important notes:
--for condition and action strings: outside with single quotes '', inside with double quotes ""!

camp_triggers = {
	
	----- CAMPAIGN INTRO ----
	["Campaign Briefing"] = {										--Trigger name
		active = true,												--Trigger is active
		once = true,												--Trigger is fired once
		condition = 'true',											--Condition of the trigger to return true or false embedded as string
		action = {													--Trigger action function embedded as string
			'Action.Text("1987, Republic of Chad - After years of civil war, fighting rages in the central area of ​​the country. In the north, Gaddafi s Libyan forces provide direct support to Goukouni Oueddei s troops. Several columns are moving towards the south of the country and threatening the town of Abeche. France supports the legitimate government of Hussein Habre.")',
			'Action.Text("Libyan forces are strong but lack effectiveness. Several columns of vehicles mixing armored vehicles and 4x4s head due south. French aviation with Mirage F-1C will try to stop them. Two EWR are available : Axeman in NDjamena and Darknight in Abeche")',
			'Action.Text("The Libyan air force includes Mig-23s and Su-22s operating from bases in Ouadi Doum and Aozou. Tu-22s are likely to intervene from Tripoli further north. Libyan defenses rely on SA-6 and SA-8 systems and several types of anti-aircraft guns. French air defense includes a battery of Hawks in NDjamena and several Crotale systems.")',
			'Action.Text("1987 - Republique du Tchad - Apres des annees  de guerre civile, les combats font rage dans la zone centrale du pays. Au Nord les forces libyennes de Kadhafi apportent un soutien direct aux troupes de Goukouni Oueddei. Plusieurs colonnes se dirigent vers le sud du pays et menacent la ville d Abeche. La France soutient le gouvernement legitime de Hussein Habre.")',	
			'Action.Text("Les forces libyennes sont importantes mais manquent d efficacité. Plusieurs colonnes de véhicules mixant blindes et 4x4 font route plein sud. L aviation française avec leurs Mirage F-1C va essayer de les arreter. Deux EWR sont disponibles : Axeman a NDjamena et Darknight a Abeche")',
			'Action.Text("L’aviation lybienne comprend des Mig-23 et des Su-22 operant depuis les bases de Ouadi Doum et de Aozou. Des Tu-22 sont susceptibles d’intervenir depuis Tripoli plus au Nord. Les defenses libyennes reposent sur des systemes SA-6 et SA-8 et plusieurs types de canons antiaeriens. La defense aerienne française comprend une batterie de Hawk à NDjamena et plusieurs systemes Crotale.")',
			'Action.AddImage("Newspaper_FirstNight_blue.jpg", "blue")',
			'Action.AddImage("Newspaper_FirstNight_red.jpg", "red")',
		},
	},
	
	
	----- CAMPAIGN END -----
	["Campaign End Victory 1"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["blue"].percent < 60',
		action = {
			'Action.CampaignEnd("win")',
			'Action.Text("Allied forces inflicted enormous losses on Libyan troops and all targets were met. The Libyans will have to leave Tchad to avoid more casualties. Good game")',
			'Action.Text("Les forces alliees ont inflige des pertes enormes aux troupes Libyennes et tous les objectifs ont ete atteints. Les Libyens vont devoir quitter le Tchad pour eviter plus de pertes. Bien joue")',
			'Action.AddImage("Newspaper_Victory_blue.jpg", "blue")',
			'Action.AddImage("Newspaper_Defeat_red.jpg", "red")',
			'NoMoreNewspaper = true',
		},
	},
	-- ["Campaign End Victory 2"] = {
		-- active = true,
		-- once = true,
		-- condition = 'Return.AirUnitReady("81 TFS") + Return.AirUnitReady("23 TFS") + Return.AirUnitReady("91 TFS") + Return.AirUnitReady("41 TFS") + Return.AirUnitReady("72 TFS") + Return.AirUnitReady("51 TFS") + Return.AirUnitReady("21 TFS") + Return.AirUnitReady("83 TFS") + Return.AirUnitReady("21-2 TFS") + Return.AirUnitReady("21-3 TFS") + Return.AirUnitReady("21-4 TFS") < 10',
		-- action = {
			-- 'Action.CampaignEnd("win")',
			-- 'Action.Text("The Islamic Republic Iranian Air Force is in ruins. After repeated air strikes and disastrous losses in air-air combat, the Iranians are no longer able to produce any sorties or offer any resistance. The US now owns complete air superiority. With the disappearance of the air threat. Once again the victorious Eagle has proved to be to leading fighter in the world. Well done.")',
			-- 'Action.AddImage("Newspaper_Victory_blue.jpg", "blue")',
			-- 'Action.AddImage("Newspaper_Defeat_red.jpg", "red")',
			-- 'NoMoreNewspaper = true',
		-- },
	-- },
	["Campaign End Loss"] = {
		active = true,
		once = true,
		condition = 'Return.AirUnitAlive("2-12 Cornouaille") < 2',
		action = {
			'Action.CampaignEnd("loss")',
			'Action.Text("Ongoing combat operations have exhausted your squadron. Loss rate has reached a level where reinforcements are no longer able to sustain combat operations. With the failure of our air force to attain air superiority, Central Command has decided to call of the air campaign against the enemy. Without destroying enemy airbases it seems unlikely that we will be able to win this war.")',
			'Action.AddImage("Newspaper_Victory_red.jpg", "red")',
			'Action.AddImage("Newspaper_Defeat_blue.jpg", "blue")',
			'NoMoreNewspaper = true',
		},
	},
	-- ["Campaign End Loss 2"] = {
		-- active = true,
		-- once = true,
		-- condition = 'Return.TargetAlive("CVN-71 Theodore Roosevelt") == 0',
		-- action = {
			-- 'Action.CampaignEnd("loss")',
			-- 'Action.Text("After the CVN-71 Theodore Roosevelt has been hit by air strikes and sunk, VF-101 is no longer able to fly. Most of its planes are deep into the Caucasian waters and it will need a long time to restore this unit s capabilities. Other US units will have to continue the fight without the VF-101 support. This is a bitter failure for the Navy")',
			-- 'Action.AddImage("Newspaper_Victory_red.jpg", "red")',
			-- 'Action.AddImage("Newspaper_Defeat_blue.jpg", "blue")',
			-- 'NoMoreNewspaper = true',
		-- },
	-- },
	["Campaign End Loss 3"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["red"].percent < 30',
		action = {
			'Action.CampaignEnd("loss")',
			'Action.Text("Libyan forces inflicted enormous losses on our troops and all targets were met. We will have to leave Chad to avoid more casualties.")',
			'Action.Text("Les forces Libyennes ont inflige des pertes enormes aux troupes ennemies et tous les objectifs ont ete atteints. Nos troupes vont devoir quitter le Tchad pour eviter plus de pertes.")',
			'Action.AddImage("Newspaper_Victory_red.jpg", "red")',
			'Action.AddImage("Newspaper_Defeat_blue.jpg", "blue")',
			'NoMoreNewspaper = true',
		},
	},
	["Campaign End Draw"] = {
		active = true,
		once = true,
		condition = 'MissionInstance == 40',
		action = {
			'Action.CampaignEnd("draw")',
			'Action.Text("The air campaign has seen a sustained period of inactivity. Seemingly unable to complete the destruction of the Libyan Air Force and infrastructure, French Central Command has called off all squadrons from offensive operations. We hope negociations with Libyan will convince them to stop moves to the south")',
			'NoMoreNewspaper = true',
		},
	},

----- CAMPAIGN SITUATION -----
	["Campaign first destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["blue"].percent < 100',
		action = {
			'Action.Text("First targets have been destroyed. Keep up the good work")',
			'Action.Text("Les premieres cibles ont ete detruites. Continuez votre bon travail")',
		},
	},
	["Campaign 20 percents destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["blue"].percent < 80',
		action = {
			'Action.Text("Enemy targets have sustained fair damages. Keep up the good work")',
			'Action.Text("Les cibles ennemies ont subi des dommages moyens. Continuez votre bon travail")',
		},
	},
	["Campaign 40 percents destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["blue"].percent < 60',
		action = {
			'Action.Text("Enemy targets have sustained great damages. Strike missions are really efficient and we will win this war soon")',
			'Action.Text("Les cibles ennemies ont subi de gros degâts. Les attaques au sol sont vraiment efficaces et nous gagnerons bientôt cette guerre")',
		},
	},
	["Campaign 50 percents destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["blue"].percent < 50',
		action = {
			'Action.Text("More than half of our targets are neutralized. Intelligence think that the enemy will ask for a cease fire soon")',
			'Action.Text("Plus de la moitie de nos cibles sont neutralisees. Les renseignements pensent que l ennemi demandera bientôt un cessez-le-feu")',
		},
	},

	----- AIRBASE STRIKES -----
	-- ["Lar Airbase Disabled"] = {
		-- active = true,
		-- condition = 'Return.TargetAlive("Lar Airbase") + Return.TargetAlive("Lar Airbase Strategics") == 0',
		-- action = {
			-- [1] = 'db_airbases["Lar Airbase"].inactive = true',
			-- [2] = 'Action.Text("After the facilities at Lar Airbase have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer able to produce any aviation sorties.")',			
		-- }
	-- },
	["Aozou Airport Disabled"] = {
		active = true,
		condition = 'Return.TargetAlive("Aozou Airport Strategics") < 20',
		action = {
			'db_airbases["Kerman Airbase"].inactive = true',
			'Action.Text("After the facilities at Aozou Airport have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer able to produce any aviation sorties.")',			
		}
	},	
	["Ouadi Doum Airport Disabled"] = {
		active = true,
		condition = 'Return.TargetAlive("Ouadi Doum Airport Strategics") < 20',
		action = {
			'db_airbases["Jiroft Airport"].inactive = true',
			'Action.AirUnitBase("1049 Squadron", "Kerman Airbase")',
			'Action.AirUnitBase("2nd Libyan SAR", "Kerman Airbase")',
			'Action.Text("After the facilities at Ouadi Doum Airport have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer able to produce any aviation sorties.")',
			'Action.Text("Apres que les installations de l aeroport de Khasab aient ete touchees par des frappes aeriennes, les operations aeriennes de cette base se sont completement arrêtees. Le renseignement estime qu en raison des lourds dommages infliges, la base n est plus en mesure de produire des sorties aeriennes.")',	
		}
	},
	["NDjamena Airport Disabled"] = {
		active = true,
		condition = 'Return.TargetAlive("NDjamena Airport") < 20 and Return.TargetAlive("NDjamena Airport Strategics") < 20',
		action = {
			'db_airbases["Bandar Abbas Intl"].inactive = true',
			'Action.CampaignEnd("loss")',
			'Action.Text("After the facilities at NDjamena have been hit by air strikes, air operations at this base came to a complete stop. The base is no longer able to produce any aviation sorties. We can t stay in Tchad any longer")',
			'Action.Text("Apres que les installations de l aeroport de NDjamena aient ete touchees par des frappes aeriennes, les operations aeriennes de cette base se sont completement arrêtees. La base n est plus en mesure de produire des sorties aeriennes. Nous allons devoir quitter le Tchad")',	
		}
	},
	
	------ Mirage F-1CE or EE Choice -------
	
	["C-135FR desactivation"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() > 0 and Return.AirUnitActive("2-12 Cornouaille")',
		action = {
		'Action.AirUnitActive("93eme ERV", false)',
		'Action.AirUnitActive("3-30 Lorraine", false)',
		},
	},
	
	
	----- TROOPS MOVEMENTS ------
	
	["Libyan Column 1 activation"] = {
		active = true,
		once = false,
		condition = 'Return.Mission() > 0',
		action = {
		'Action.TemplateActive("Libyan Column 1 T1.stm","Libyan Column 1 T2.stm","Libyan Column 1 T3.stm","Libyan Column 1 T4.stm")',	
		},
	},
	["Libyan Column 2 activation"] = {
		active = true,
		once = false,
		condition = 'Return.Mission() > 0',
		action = {
		'Action.TemplateActive("Libyan Column 2 T1.stm","Libyan Column 2 T2.stm","Libyan Column 2 T3.stm","Libyan Column 2 T4.stm")',	
		},
	},
	["Libyan Supply column 1 activation"] = {
		active = true,
		once = false,
		condition = 'Return.Mission() > 0',
		action = {
		'Action.TemplateActive("Libyan Supply Column 1 T1.stm","Libyan Supply Column 1 T2.stm","Libyan Supply Column 1 T3.stm","Libyan Supply Column 1 T4.stm")',	
		},
	},
	["Libyan Supply Column 2 activation"] = {
		active = true,
		once = false,
		condition = 'Return.Mission() > 0',
		action = {
		'Action.TemplateActive("Libyan Supply column 2 T1.stm","Libyan Supply column 2 T2.stm","Libyan Supply column 2 T3.stm","Libyan Supply column 2 T4.stm")',	
		},
	},
	
	
	----- RED CAP -----
	["CAP After EWR Destroyed"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("EWR-Ouadi Doum") == 0 and Return.TargetAlive("EWR-Aozou") == 0',
		action = {
			'Action.TargetActive("Ouadi Doum Alert", false)',
			'Action.TargetActive("Aozou Alert", false)',
			'Action.TargetActive("CAP Ouadi Doum", true)',
			'Action.TargetActive("CAP Aozou", true)',
			'Action.Text("With the recent destruction of all Early Warning Radar sites in the operations area, the ability of the enemy to launch interceptors against our strike packages was severely degraded. Intelligence expects that the enemy will increasingly depend on Combat Air Patrols to compensate, though without the support of ground controllers these are estimated to be of limited effectiveness.")',
			'Action.Text("Avec la destruction recente de tous les sites de radar d alerte precoce dans la zone d operations, la capacite de l ennemi à lancer des intercepteurs contre nos paquets de frappe a ete gravement degradee. Le renseignement s attend à ce que l ennemi depende de plus en plus des CAP pour compenser, bien que sans le soutien des contrôleurs au sol, on estime que leur efficacite est limitee.")',
		},
	},		
	
	----- REPAIR AND REINFORCEMENTS -----
	["GroundUnitRepair"] = {
		active = true,
		condition = 'true',
		action = 'Action.GroundUnitRepair()',
	},
	["Repair"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitRepair()',
	},
	

	
	---- GROUND TARGET STATUS ---
	["Blue Ground Target Briefing Intel"] = {
		active = true,
		condition = 'true',
		action = 'Action.AddGroundTargetIntel("blue")',
	},
	["Red Ground Target Briefing Intel"] = {
		active = true,
		condition = 'true',
		action = 'Action.AddGroundTargetIntel("red")',
	},
	
	

}